<?php
  require("connzara.php"); 

// Include the main TCPDF library (search for installation path).
require_once('tcpdf_include.php');

// extend TCPF with custom functions
class MYPDF extends TCPDF {

	// Load table data from file
	public function LoadData($file) {
		// Read file lines
		$lines = file($file);
		$data = array();
		foreach($lines as $line) {
			$data[] = explode(';', chop($line));
		}
		return $data;
	}

	// Colored table
	public function ColoredTable($header,$data) {
		// Colors, line width and bold font
		$this->SetFillColor(43, 53, 148);
		$this->SetTextColor(255);
		$this->SetDrawColor(128, 0, 0);
		$this->SetLineWidth(0.3);
		$this->SetFont('', 'B');
		// Header
		$w = array(20,120, 40 );
		$num_headers = count($header);
		for($i = 0; $i < $num_headers; ++$i) {
			$this->Cell($w[$i], 7, $header[$i], 1, 0, 'L', 1);
		}
		$this->Ln();
		// Color and font restoration
		$this->SetFillColor(224, 235, 255);
		$this->SetTextColor(0);
		$this->SetFont('');
		// Data
		$fill = 0;
		foreach($data as $row) {
			$this->Cell($w[0], 6, $row[0], 'LR', 0, 'L', $fill);
			$this->Cell($w[1], 6, $row[1], 'LR', 0, 'L', $fill);
			$this->Cell($w[2], 6, $row[2], 'LR', 0, 'L', $fill); 
			$this->Ln();
			$fill=!$fill;
		}
		$this->Cell(array_sum($w), 0, '', 'T');
	}
}

// create new PDF document
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$queryk=mysqli_query($con,'SELECT COMPANYNAME,concat(PHYSICALADD," Phone ",PHONE1,"\n",email,"  ",WEB)PHYSICALADD   FROM companyinfo c;');
$rowa=mysqli_fetch_array($queryk); 
 
  
 
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Skeva Tech Ltd');
$pdf->SetTitle('Income Statement');
$pdf->SetSubject(' Income Statement');
$pdf->SetSubject(' Income Statement'); 
//$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, $rowa['COMPANYNAME'] , $rowa['PHYSICALADD'], array(0,64,277), array(0,64,128));

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
	require_once(dirname(__FILE__).'/lang/eng.php');
	$pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('helvetica', '', 12);

// add a page
$pdf->AddPage(); 
 
$query=mysqli_query($con,"select year('".$_SESSION['dtto']."')yrs from dual");
$row=mysqli_fetch_array($query); 
$_SESSION['cyr']=$row['yrs'];
 $cyr=$_SESSION['cyr'];
 $pyr=$cyr-1; 
// column titles 
  
 $pdf->Cell(40,10,'  STATEMENT OF FINANCIAL POSITION');
 $pdf->Ln(5); 
 $pdf->Cell(40,10,'  FOR THE YEAR ENDED '.$_SESSION['cyr']); 
 $pdf->Ln(); 
 $pdf->SetFont('helvetica','B',10);
  $pdf->Cell(100,10,'  ');
  $pdf->Cell(30,10,'  '); 
  $pdf->Cell(30,10,$cyr,'','','R');
  $pdf->Cell(30,10,$pyr,'','','R');
  
  $pdf->Ln(5); 
  $pdf->Cell(100,10,'  ');
  $pdf->Cell(30,10,'Notes');
  $pdf->Cell(30,10,'Ksh','','','R');
  $pdf->Cell(30,10,'Ksh','','','R');
  
  //Assets
  $pdf->Ln(5);
  $pdf->Cell(100,10,'ASSETS:');
  $pdf->Cell(30,10,' ');
  $pdf->Cell(30,10,' ');
  $pdf->Cell(30,10,' '); 
  
  $pdf->Ln(5);
  $pdf->Cell(100,10,'Current Assets:');
  $pdf->Cell(30,10,' ');
  $pdf->Cell(30,10,' ');
  $pdf->Cell(30,10,' '); 
  
  

  //cash > 0
 // Cash & Bank
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT   round(sum(Amount))
  Amount FROM (
   select AccId,sum(coalesce(DrAmount,0)-coalesce(CrAmount,0))Amount  from  cashtrans  where Year(TrDate)<=$cyr
group by AccId
having sum(coalesce(DrAmount,0)-coalesce(CrAmount,0))>0
union
select 0, sum(coalesce(DrAmount,0)-coalesce(CrAmount,0))Amount  from  tellertrans  where Year(TrDate)<=$cyr
having sum(coalesce(DrAmount,0)-coalesce(CrAmount,0))>0 
   ) i"));
  echo mysqli_error($con);
   $pnrow=mysqli_fetch_array(mysqli_query($con,"SELECT  round(sum(Amount))
  Amount FROM (
  
   select AccId,sum(coalesce(DrAmount,0)-coalesce(CrAmount,0))Amount  from  cashtrans  where Year(TrDate)<=$pyr
group by AccId
having sum(coalesce(DrAmount,0)-coalesce(CrAmount,0))>0
union
select 0, sum(coalesce(DrAmount,0)-coalesce(CrAmount,0))Amount  from  tellertrans  where Year(TrDate)<=$pyr
  ) i"));
  echo mysqli_error($con); 
  $catot=$catot+round($inrow['Amount']) ; 
  $patot=$patot+round($pnrow['Amount']) ;
  if(  $pnrow['Amount']!=0 ||$inrow['Amount']!=0){ 
  $pdf->Ln(6);
  $pdf->Cell(100,10,'Cash and bank balances');
  $pdf->Cell(30,10,' ');
  $pdf->Cell(30,10,number_format(  $inrow['Amount'],0,".",","),'','','R');
  $pdf->Cell(30,10,number_format(  $pnrow['Amount'],0,".",","),'','','R'  );
  }
  /// Prepayments
   $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT round( sum(coalesce(DrAmount,0)-coalesce(CrAmount,0))) 
     Amount FROM custtrans   i   where custId>0 and  custId<>2  and Year(TrDate)<=$cyr "));
    $catot=$catot+round($inrow['Amount']) ;  
   $pnrow=mysqli_fetch_array(mysqli_query($con,"SELECT round(sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) )
  Amount FROM custtrans i where custId>0 and  custId<>2 and  Year(TrDate)<=$pyr ")); 
	$patot=$patot+round( $pnrow['Amount']) ;
	
	
	 if(  $pnrow['Amount']!=0 ||$inrow['Amount']!=0){
	$pdf->Ln(6);
   $pdf->Cell(100,10,'Prepayments and other Receivables');
   $pdf->Cell(30,10,' ');  
    $pdf->Cell(30,10,number_format(  $inrow['Amount'],0,".",","),'','','R'  ); 
    $pdf->Cell(30,10,number_format(   $pnrow['Amount'],0,".",","),'','','R'  ); 
	 }
	 
	  /// Feestrans
   $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT round(sum(Amount)) Amount FROM (SELECT   sum(coalesce(DrAmount,0)-coalesce(CrAmount,0))  
     Amount FROM  feestrans    i   where stno>0 and Year(TrDate)<=$cyr
	   union SELECT  sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) 
     Amount FROM custtrans   i   where   custId=2  and Year(TrDate)<=$cyr)i"));
    $catot=$catot+round($inrow['Amount']) ;  
   $pnrow=mysqli_fetch_array(mysqli_query($con,"SELECT round(sum(Amount)) Amount FROM (SELECT  sum(coalesce(DrAmount,0)-coalesce(CrAmount,0))  
  Amount FROM feestrans i where stno>0 and  Year(TrDate)<=$pyr
    union SELECT  sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) 
     Amount FROM custtrans   i   where   custId=2  and Year(TrDate)<=$pyr)i ")); 
	$patot=$patot+round( $pnrow['Amount']) ;
	
	
	 if(  $pnrow['Amount']!=0 ||$inrow['Amount']!=0){
	$pdf->Ln(6);
   $pdf->Cell(100,10,'Student Receivables');
   $pdf->Cell(30,10,' ');  
    $pdf->Cell(30,10,number_format(  $inrow['Amount'],0,".",","),'','','R'  ); 
    $pdf->Cell(30,10,number_format(   $pnrow['Amount'],0,".",","),'','','R'  ); 
	 }
	 
	
	 /// Investments 
    $inrow=mysqli_fetch_array(mysqli_query($con,"  SELECT round(sum(Amount)) Amount FROM (
           SELECT  sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) Amount FROM invesmenttrans i where Year(TrDate)<=$cyr
		  
	 ) i"));  
   $pnrow=mysqli_fetch_array(mysqli_query($con,"SELECT round(sum(Amount)) Amount FROM (
           SELECT  sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) Amount FROM invesmenttrans i where Year(TrDate)<=$pyr
		 
	 
	 ) i"));
	 $catot=$catot+round($inrow['Amount']) ;  
	 $patot=$patot+round($pnrow['Amount']) ;
  if(  $pnrow['Amount']!=0||$inrow['Amount']!=0){ 
   $pdf->Ln(6);
   $pdf->Cell(100,10,'Investments');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,number_format(  $inrow['Amount'],0,".",","),'','','R'  ); 
    $pdf->Cell(30,10,number_format(  $pnrow['Amount'],0,".",","),'','','R'  );
	}
  // Advance To Members
  
    
   
   
    $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT  round(sum(coalesce(DrQty*cost,0)- coalesce(CrQty*cost,0)))
     Amount FROM itemstrans i where Year(TrDate)<=$cyr "));
	 $pnrow=mysqli_fetch_array(mysqli_query($con,"SELECT  round(sum(coalesce(DrQty*cost,0)- coalesce(CrQty*cost,0)))
     Amount FROM itemstrans i where Year(TrDate)<=$pyr "));
  
    $catot=$catot+round($inrow['Amount']) ;  
	$patot=$patot+round($pnrow['Amount']) ;  
 
   if($pnrow['Amount']!=0||$inrow['Amount']!=0){ 
     $pdf->Ln(6);
     $pdf->Cell(100,10,'Stock Items'); 
     $pdf->Cell(30,10,' ');
     $pdf->Cell(30,10,number_format(  $inrow['Amount'],0,".",","),'','','R'  ); 
	 $pdf->Cell(30,10,number_format(  $pnrow['Amount'],0,".",","),'','','R'  );
   }
    $pdf->Ln(1);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'____________','','','R' );
   $pdf->Cell(30,10,'____________','','','R' );
   $pdf->Ln(5);
  $pdf->Cell(100,10,'Total Current Assets:');
  $pdf->Cell(30,10,' ');
  $pdf->Cell(30,10,number_format(  $catot,0,".",","),'','','R' );
  $pdf->Cell(30,10,number_format(  $patot,0,".",","),'','','R' );  
   $pdf->Ln(5);
  $pdf->Cell(100,10,'');
  $pdf->Cell(30,10,' ');
  $pdf->Cell(30,10,' ');
  $pdf->Cell(30,10,' ');  
  
   $pdf->Ln(5);
  $pdf->Cell(100,10,'Less: current liabilities:');
  $pdf->Cell(30,10,' ');
  $pdf->Cell(30,10,' ');
  $pdf->Cell(30,10,' ');  
   
   //cash overdraft > 0
 
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT  round(sum(Amount))
  Amount FROM (
  
   select AccId,sum(coalesce(CrAmount,0)-coalesce(DrAmount,0))Amount  from  cashtrans  where Year(TrDate)<=$cyr
group by AccId
having sum(coalesce(DrAmount,0)-coalesce(CrAmount,0))<0
union
select 0, sum(coalesce(CrAmount,0)-coalesce(DrAmount,0))Amount  from  tellertrans  where Year(TrDate)<=$cyr
having sum(coalesce(DrAmount,0)-coalesce(CrAmount,0))<0
  ) i "));
  
    $pnrow=mysqli_fetch_array(mysqli_query($con,"SELECT  round(sum(Amount))
  Amount FROM ( 
   select AccId,sum(coalesce(CrAmount,0)-coalesce(DrAmount,0))Amount  from  cashtrans  where Year(TrDate)<=$pyr
group by AccId
having sum(coalesce(DrAmount,0)-coalesce(CrAmount,0))<0
union
select 0, sum(coalesce(CrAmount,0)-coalesce(DrAmount,0))Amount  from  tellertrans  where Year(TrDate)<=$pyr
having sum(coalesce(DrAmount,0)-coalesce(CrAmount,0))<0) i"));
   $cltot=$cltot+round($inrow['Amount']) ;
   $pltot=$pltot+round($pnrow['Amount']) ;
     if($pnrow['Amount']!=0||$inrow['Amount']!=0){ 
   
  $pdf->Ln(6);
  $pdf->Cell(100,10,' Bank Overdraft');
  $pdf->Cell(30,10,' ');
  $pdf->Cell(30,10,number_format(  $inrow['Amount'],0,".",","),'','','R'); 
   $pdf->Cell(30,10,number_format(  $pnrow['Amount'],0,".",","),'','','R'  );

  
	 }
  // creditors
  $inrow=mysqli_fetch_array(mysqli_query($con,"  
  SELECT  round(sum(Amount))  Amount FROM (
           SELECT  sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) Amount FROM vendortrans i where Year(TrDate)<=$cyr  and  suppId in(select  suppId from  vendor  where coalesce(annualpay,0)=0 )  ) i  "));
  $pnrow=mysqli_fetch_array(mysqli_query($con,"SELECT round(sum(Amount))  Amount FROM (
        SELECT  sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) Amount  FROM vendortrans i where Year(TrDate)<=$pyr  and suppId  in(select  suppId from  vendor  where coalesce(annualpay,0)=0 ) ) i  ")); 
  $cltot=$cltot+round($inrow['Amount']) ;  
     $pltot=$pltot+round($pnrow['Amount']) ; 
    if($pnrow['Amount']!=0||$inrow['Amount']!=0){ 
  $pdf->Ln(6);
  $pdf->Cell(100,10,'Sundry Creditors');
  $pdf->Cell(30,10,' ');
  $pdf->Cell(30,10,number_format(  $inrow['Amount'],0,".",","),'','','R'  ); 
  $pdf->Cell(30,10,number_format(  $pnrow['Amount'],0,".",","),'','','R'  );
  
	}
	
  // loan payable within a year
  $inrow=mysqli_fetch_array(mysqli_query($con,"  
 select sum(  annualpay )Amount from  vendor  where suppId in(SELECT   i.suppId  FROM vendortrans i join vendor v on(i.suppid=v.suppid) and annualpay>0 and  Year(TrDate)<=$cyr  group by suppid,annualpay having sum(coalesce(CrAmount,0)-coalesce(DrAmount,0))>annualpay)  "));
  $pnrow=mysqli_fetch_array(mysqli_query($con,"select sum(  annualpay )Amount from  vendor  where suppId in(SELECT   i.suppId  FROM vendortrans i join vendor v on(i.suppid=v.suppid) and annualpay>0 and  Year(TrDate)<=$pyr  group by suppid,annualpay having sum(coalesce(CrAmount,0)-coalesce(DrAmount,0))>annualpay)  ")); 
  $cltot=$cltot+round($inrow['Amount']) ;  
     $pltot=$pltot+round($pnrow['Amount']) ; 
    if($pnrow['Amount']!=0||$inrow['Amount']!=0){ 
  $pdf->Ln(6);
  $pdf->Cell(100,10,'Short Term Loans');
  $pdf->Cell(30,10,' ');
  $pdf->Cell(30,10,number_format(  $inrow['Amount'],0,".",","),'','','R'  ); 
  $pdf->Cell(30,10,number_format(  $pnrow['Amount'],0,".",","),'','','R'  );
  
	}
	 $pdf->Ln(1);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'____________','','','R' );
   $pdf->Cell(30,10,'____________','','','R' );
  $pdf->Ln(5);
  $pdf->Cell(100,10,'Total Current Liabilities:');
  $pdf->Cell(30,10,' ');
  $pdf->Cell(30,10,number_format(  $cltot,0,".",","),'','','R' );
  $pdf->Cell(30,10,number_format(  $pltot,0,".",","),'','','R' );  
   $pdf->Ln(5);
  $pdf->Cell(100,10,'');
  $pdf->Cell(30,10,' ');
  $pdf->Cell(30,10,' ');
  $pdf->Cell(30,10,' '); 
  
   $pdf->Ln(1);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'____________','','','R' );
   $pdf->Cell(30,10,'____________','','','R' );
    $pdf->Ln(5);
  $pdf->Cell(100,10,'Working Capital:');
  $pdf->Cell(30,10,' ');
   $cwtot=$catot-$cltot;
   $pwtot=$patot-$pltot;
   
    $catot=0;$cltot=0;
    $patot=0;$pltot=0;
   
 $pdf->Cell(30,10,number_format(  $cwtot,0,".",","),'','','R' );
  $pdf->Cell(30,10,number_format(  $pwtot,0,".",","),'','','R' );   
  $pdf->Ln(1);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'____________','','','R' );
   $pdf->Cell(30,10,'____________','','','R' );  
   $pdf->Ln(5);
  $pdf->Cell(100,10,'');
  $pdf->Cell(30,10,' ');
  $pdf->Cell(30,10,' ');
  $pdf->Cell(30,10,' ');
   
  
   $pdf->Ln(5);
  $pdf->Cell(100,10,'FIXED ASSETS:');
  $pdf->Cell(30,10,' ');
  $pdf->Cell(30,10,' ');
  $pdf->Cell(30,10,' '); 
  
   ///Tagible assets
    $qry=mysqli_query($con,'select MinMonths FROM shares;');
	$rws=mysqli_fetch_array($qry);  
	if($rws['MinMonths']==0){
 
     $inrow=mysqli_fetch_array(mysqli_query($con," 
	select sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) Amount  from  fxassettrans  where Year(TrDate)<=$cyr
	 and Asid in(SELECT Asid FROM fxasset    where coalesce(typ,'')!='I') "
	));
	 
   $pnrow=mysqli_fetch_array(mysqli_query($con," 
	select sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) Amount  from  fxassettrans  where Year(TrDate)<=$pyr
	 and Asid in(SELECT Asid FROM fxasset where   coalesce(typ,'')!='I') ")); 
	 echo mysqli_error($con);  
    $catot=$catot+round($inrow['Amount']) ; 
	$patot=$patot+round($pnrow['Amount']) ; 
	 
  if(  $pnrow['Amount']!=0 || $inrow['Amount']!=0){ 
   $pdf->Ln(6);
   $pdf->Cell(100,10,'Property,plant and Equipment');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,number_format(  $inrow['Amount'],0,".",","),'','','R'  ); 
    $pdf->Cell(30,10,number_format(  $pnrow['Amount'],0,".",","),'','','R'  );
	}
	
	 $inrow=mysqli_fetch_array(mysqli_query($con," 
	select sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) Amount  from  fxassettrans  where Year(TrDate)<=$cyr
	 and Asid in(SELECT Asid FROM fxasset  where   coalesce(typ,'')='I') "
	));
	 
   $pnrow=mysqli_fetch_array(mysqli_query($con," 
	select sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) Amount  from  fxassettrans  where Year(TrDate)<=$pyr
	 and Asid in(SELECT Asid FROM fxasset  where  coalesce(typ,'')='I') ")); 
	 echo mysqli_error($con);  
    $catot=$catot+round($inrow['Amount']) ; 
	$patot=$patot+round($pnrow['Amount']) ; 
	 
  if(  $pnrow['Amount']!=0||$inrow['Amount']!=0){ 
   $pdf->Ln(6);
   $pdf->Cell(100,10,'Intagible assets');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,number_format(  $inrow['Amount'],0,".",","),'','','R'  ); 
    $pdf->Cell(30,10,number_format(  $pnrow['Amount'],0,".",","),'','','R'  );
	}
	}else{
		
	$qry=mysqli_query($con,'SELECT Asid,Descr FROM fxasset;');
	while($rws=mysqli_fetch_array($qry)){ 

     $inrow=mysqli_fetch_array(mysqli_query($con," 
	select sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) Amount  from  fxassettrans  where Year(TrDate)<=$cyr
	and Asid =".$rws['Asid']));
	 
   $pnrow=mysqli_fetch_array(mysqli_query($con," 
	select sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) Amount  from  fxassettrans  where Year(TrDate)<=$pyr
	 and  Asid =".$rws['Asid'])); 
	 echo mysqli_error($con);  
    $catot=$catot+round($inrow['Amount']) ; 
	$patot=$patot+round($pnrow['Amount']) ; 
	 
  if(  $pnrow['Amount']!=0 || $inrow['Amount']!=0){ 
   $pdf->Ln(6);
   $pdf->Cell(100,10,$rws['Descr']);
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,number_format(  $inrow['Amount'],0,".",","),'','','R'  ); 
    $pdf->Cell(30,10,number_format(  $pnrow['Amount'],0,".",","),'','','R'  );
	}
	
	 
		
		
	}
		
		}
	
 $pdf->Ln(5);
  $pdf->Cell(100,10,'Total Fixed Assets:');
  $pdf->Cell(30,10,' ');
  $pdf->Cell(30,10,number_format(  $catot,0,".",","),'','','R' );
  $pdf->Cell(30,10,number_format(  $patot,0,".",","),'','','R' ); 
	
    $pdf->SetFont('helvetica','B',10); 
   $pdf->Ln(1);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'____________','','','R' );
   $pdf->Cell(30,10,'____________','','','R' );
   $cktot=$catot+$cwtot;
   $pktot=$patot+$pwtot;
    
   $pdf->Ln(6);
   $pdf->Cell(100,10,'Total Assets');
   $pdf->Cell(30,10,' ');
    $pdf->Cell(30,10,number_format( $cktot,0,".",","),'','','R' ); 
   $pdf->Cell(30,10,number_format( $pktot,0,".",","),'','','R' );
  
   
  
    $pdf->Ln(1);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'____________','','','R' ); 
   $pdf->Cell(30,10,'____________','','','R' );
   
 
   //Liabilities
   
  
   $pdf->Ln(6);
   $pdf->Cell(100,10,'Long Term Liabilities:');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'');
   $pdf->Cell(30,10,'');
   $cltot=0;  $pltot=0;
   
  
   // in more than one year
  $inrow=mysqli_fetch_array(mysqli_query($con,"  
   SELECT  sum(coalesce(CrAmount,0)-coalesce(DrAmount,0))-annualpay Amount, annualpay, i.suppid FROM vendortrans i join vendor v on(i.suppid=v.suppid) and annualpay>0 and  Year(TrDate)<=$cyr  group by suppid,annualpay having sum(coalesce(CrAmount,0)-coalesce(DrAmount,0))>annualpay "));
  $pnrow=mysqli_fetch_array(mysqli_query($con,"SELECT  sum(coalesce(CrAmount,0)-coalesce(DrAmount,0))-annualpay Amount , annualpay, i.suppid   FROM vendortrans i join vendor v on(i.suppid=v.suppid) and annualpay>0 and  Year(TrDate)<=$pyr  group by suppid,annualpay having sum(coalesce(CrAmount,0)-coalesce(DrAmount,0))>annualpay ")); 
  $cltot=$cltot+round($inrow['Amount']) ;  
     $pltot=$pltot+round($pnrow['Amount']) ; 
    if($pnrow['Amount']!=0||$inrow['Amount']!=0){ 
  $pdf->Ln(6);
  $pdf->Cell(100,10,'Long Term Loans');
  $pdf->Cell(30,10,' ');
  $pdf->Cell(30,10,number_format(  $inrow['Amount'],0,".",","),'','','R'  ); 
  $pdf->Cell(30,10,number_format(  $pnrow['Amount'],0,".",","),'','','R'  );
  
	}
    $pdf->Ln(6);
   $pdf->Cell(100,10,'EQUITY');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'');
   $pdf->Cell(30,10,'');	 
   
   /// Unallocated Fund balance 
    $inrow=mysqli_fetch_array(mysqli_query($con,"  SELECT round(sum(Amount)) Amount FROM (
           SELECT  sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) Amount FROM capitalacc  i where Year(TrDate)<=$cyr
		   union    SELECT  sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) Amount  FROM  inctrans i where    Year(TrDate)<$cyr    and tr is null  
	  union  SELECT sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) Amount FROM feestrans  i where Year(TrDate)<$cyr  and TK in('FBLL')
	   union   SELECT  sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) Amount  FROM  exptrans i where    Year(TrDate)<$cyr 
	 ) i"));  
	 echo mysqli_error($con);
   $pnrow=mysqli_fetch_array(mysqli_query($con,"SELECT round(sum(Amount)) Amount FROM (
           SELECT  sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) Amount FROM capitalacc  i where Year(TrDate)<=$pyr
		union    SELECT  sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) Amount  FROM  inctrans i where    Year(TrDate)<$pyr  and  tr is null  
	  union  SELECT sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) Amount FROM feestrans  i where Year(TrDate)<$pyr  and TK in('FBLL')
	   union   SELECT  sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) Amount  FROM  exptrans i where    Year(TrDate)<$pyr  
	 
	 ) i"));
	 $cltot=$cltot+round($inrow['Amount']) ;  
	 $pltot=$pltot+round($pnrow['Amount']) ;
	  echo mysqli_error($con);
  if(  $pnrow['Amount']!=0||$inrow['Amount']!=0){ 
   $pdf->Ln(6);
   $pdf->Cell(100,10,'Unallocated Fund balance');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,number_format(  $inrow['Amount'],0,".",","),'','','R'  ); 
    $pdf->Cell(30,10,number_format(  $pnrow['Amount'],0,".",","),'','','R'  );
	}
	
	
   
 
  
  $inrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(Amount) Amount FROM (
	  SELECT  sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) Amount  FROM  inctrans i where    Year(TrDate)=$cyr  and stno=1 and tr is null  
	  union  SELECT sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) Amount FROM feestrans  i where Year(TrDate)=$cyr and TK in('FBLL')
	   union   SELECT  sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) Amount  FROM  exptrans i where    Year(TrDate)=$cyr   
	 
	 
	 ) i"));
	 $pnrow=mysqli_fetch_array(mysqli_query($con,"SELECT sum(Amount) Amount FROM (
	SELECT  sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) Amount  FROM  inctrans i where   Year(TrDate)=$pyr  and stno=1 and tr is null  
   union    SELECT sum(coalesce(DrAmount,0)-coalesce(CrAmount,0)) Amount FROM feestrans  i where Year(TrDate)=$pyr $where  and TK in('FBLL')
   union   SELECT  sum(coalesce(CrAmount,0)-coalesce(DrAmount,0)) Amount  FROM  exptrans i where    Year(TrDate)=$pyr 
	 
	 ) i"));
	 echo mysqli_error($con); 
	  
	     $cltot=$cltot+round($inrow['Amount']) ; 
  $pltot=$pltot+round($pnrow['Amount']) ;  
  
  $pdf->Ln(6);
  $pdf->Cell(100,10,'Surplus');
  $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,number_format(  $inrow['Amount'],0,".",","),'','','R'  );
   $pdf->Cell(30,10,number_format(  $pnrow['Amount'],0,".",","),'','','R'  );
  
    $pdf->Ln(1);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'____________','','','R' );
   $pdf->Cell(30,10,'____________','','','R' );
    $pdf->SetFont('helvetica','B',10); 
   $pdf->Ln(6);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
    $pdf->Cell(30,10,number_format( $cltot,0,".",","),'','','R' ); 
   $pdf->Cell(30,10,number_format( $pltot,0,".",","),'','','R' );
  
   
   $pdf->Ln(1);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'____________','','','R' );
   $pdf->Cell(30,10,'____________','','','R' );
   $pdf->Ln(1);
   $pdf->Cell(100,10,'');
   $pdf->Cell(30,10,' ');
   $pdf->Cell(30,10,'____________','','','R' );
   $pdf->Cell(30,10,'____________','','','R' );
 //
 
 $pdf->lastPage(); 
 $query=mysqli_query($con,"SELECT pdfnm FROM tblpdfs t;");
 while($row=mysqli_fetch_array($query)){
	 $filename = $row["pdfnm"].".pdf";
 
if (file_exists($filename)) {
     unlink($filename);
}
}
	 
	  mysqli_query($con,"delete from tblpdfs ;");
	  $query=mysqli_query($con,"SELECT date_format((select if(sysuse='T',TrDate,now()) state from systactive),'pdf_%H%i%S') nname FROM dual ;");
	  $row=mysqli_fetch_array($query); 
	  $nname=$_SERVER['SCRIPT_FILENAME'];
	    $base=basename($_SERVER['PHP_SELF']); 
		$nname=str_replace($base,'', $nname); 
	   $nname=$nname.'pdfs/'.$row['nname'];
	  mysqli_query($con,"insert into tblpdfs(pdfnm)values('".$nname."');"); 
     $pdf->Output($nname.".pdf","I");